<?php
namespace Application\Block\Announcement;

use Concrete\Core\Block\BlockController;

class Controller extends BlockController
{
    protected $btInterfaceWidth = "500";
    protected $btInterfaceHeight = "300";

    public function getBlockTypeDescription()
    {
        return t("Fetch and display announcements from a GraphQL API.");
    }

    public function getBlockTypeName()
    {
        return t("Announcement");
    }

    // This runs before rendering view.php
    public function view()
    {
        $this->set('announcements', $this->fetchAnnouncements());
    }

    // Fetch data from GraphQL API
    private function fetchAnnouncements()
    {
        // ✅ Updated GraphQL endpoint
        $graphqlUrl = "http://172.23.183.41:8040/graphql/announcement";

        // ✅ Updated GraphQL query
        $query = <<<GQL
query Announcements {
    announcements {
        id
        title
        image
        content
        created_at
        updated_at
    }
}
GQL;

        $ch = curl_init($graphqlUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['query' => $query]));
        $response = curl_exec($ch);
        curl_close($ch);

        $data = json_decode($response, true);

        if (isset($data['data']['announcements'])) {
            return $data['data']['announcements'];
        }

        return [];
    }
}
