<?php defined('C5_EXECUTE') or die("Access Denied."); ?>

<div class="announcement-block">
    <?php if (!empty($announcements)): ?>
        <ul class="announcement-list">
            <?php foreach ($announcements as $item): ?>
                <li class="announcement-item">
                    <h3><?php echo h($item['title']); ?></h3>
                    <?php if (!empty($item['image'])): ?>
                        <img src="<?php echo h($item['image']); ?>" alt="<?php echo h($item['title']); ?>">
                    <?php endif; ?>
                    <p><?php echo h($item['content']); ?></p>
                    <small>Created at: <?php echo h($item['created_at']); ?></small>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php else: ?>
        <p>No announcements found.</p>
    <?php endif; ?>
</div>

<style>
.announcement-block {
    width: 100%;              /* Full width */
    max-width: 100%;
    height: 300px;            /* Fixed medium height */
    overflow-y: auto;         /* Vertical scroll when needed */
    overflow-x: hidden;       /* Prevent horizontal scroll */
    border: 1px solid #ccc;   /* Optional border */
    border-radius: 6px;
    padding: 10px;
    background: #fafafa;      /* Light background */
    box-sizing: border-box;
}

.announcement-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.announcement-item {
    margin-bottom: 15px;
    padding: 10px;
    border-bottom: 1px solid #ddd;
}

.announcement-item:last-child {
    border-bottom: none;
}

.announcement-item h3 {
    margin: 0 0 8px;
    font-size: 16px;
}

.announcement-item img {
    max-width: 100%;
    height: auto;
    display: block;
    margin-bottom: 8px;
}
</style>
