<?php
namespace Application\Block\CustomLogin;

use Concrete\Core\Block\BlockController;
use Concrete\Core\Http\ResponseFactoryInterface;
use Concrete\Core\Session\SessionValidatorInterface;

class Controller extends BlockController
{
    protected $btInterfaceWidth = 400;
    protected $btInterfaceHeight = 500;

    public function getBlockTypeDescription()
    {
        return t('Custom Login Block with Hardcoded Authentication');
    }

    public function getBlockTypeName()
    {
        return t('Custom Login');
    }

    public function view()
    {
        // Use Concrete CMS's session service
        $session = $this->app->make('session');
        $isLoggedIn = $session->get('custom_logged_in', false);
        $username = $session->get('custom_user', '');
        
        $this->set('isCustomLoggedIn', $isLoggedIn);
        $this->set('customUsername', $username);
        
        // Also set for template access
        $this->set('session', $session);
    }

    public function action_custom_login()
    {
        if ($this->request->isMethod('POST')) {
            $username = $this->post('username');
            $password = $this->post('password');
            
            // Hardcoded authentication
            $authResult = $this->authenticateUser($username, $password);
            
            if ($authResult['success']) {
                // Use Concrete CMS's session service properly
                $session = $this->app->make('session');
                
                // Set custom session variables
                $session->set('custom_user', $username);
                $session->set('custom_user_data', $authResult['user_data']);
                $session->set('custom_logged_in', true);
                $session->set('custom_login_time', time());
                
                // Use Concrete CMS's flash message system
                $this->app->make('session')->getFlashBag()->add('success', t('Login successful!'));
                
                // Redirect using Concrete CMS's response factory
                return $this->app->make(ResponseFactoryInterface::class)
                    ->redirect('/concrete/concrete-cms-9.2.8/userdashboard/', 302);
                
            } else {
                $this->set('error', $authResult['message']);
                $this->set('username', $username);
            }
        }
    }

    public function action_custom_logout()
    {
        // Use Concrete CMS's session service
        $session = $this->app->make('session');
        
        // Clear custom session variables
        $session->remove('custom_user');
        $session->remove('custom_user_data');
        $session->remove('custom_logged_in');
        $session->remove('custom_login_time');
        
        // Add flash message
        $session->getFlashBag()->add('info', t('You have been logged out.'));
        
        // Redirect to home
        return $this->app->make(ResponseFactoryInterface::class)
            ->redirect('/', 302);
    }

    private function authenticateUser($username, $password)
    {
        // Hardcoded credentials
        $validUsers = [
            'user1' => [
                'password' => 'user123',
                'user_data' => [
                    'username' => 'user1',
                    'email' => 'user1@example.com',
                    'full_name' => 'John Doe',
                    'role' => 'administrator',
                    'member_since' => '2024-01-01'
                ]
            ],
            'user2' => [
                'password' => 'user456',
                'user_data' => [
                    'username' => 'user2',
                    'email' => 'user2@example.com',
                    'full_name' => 'Jane Smith',
                    'role' => 'subscriber',
                    'member_since' => '2024-02-01'
                ]
            ],
            'admin' => [
                'password' => 'admin123',
                'user_data' => [
                    'username' => 'admin',
                    'email' => 'admin@example.com',
                    'full_name' => 'System Administrator',
                    'role' => 'super_admin',
                    'member_since' => '2024-01-01'
                ]
            ]
        ];

        if (!isset($validUsers[$username])) {
            return ['success' => false, 'message' => t('Invalid username')];
        }

        if ($validUsers[$username]['password'] !== $password) {
            return ['success' => false, 'message' => t('Invalid password')];
        }

        return [
            'success' => true,
            'user_data' => $validUsers[$username]['user_data']
        ];
    }
}