<?php
defined('C5_EXECUTE') or die('Access Denied.');

$isCustomLoggedIn = $isCustomLoggedIn ?? false;
$customUsername = $customUsername ?? '';
?>

<div class="custom-login-block">
    <div id="flash-messages"></div>

    <?php if ($isCustomLoggedIn): ?>
        <div class="alert alert-info">
            <p>Welcome back, <strong><?= h($customUsername) ?></strong>!</p>
            <div class="mt-2">
                <a href="/user-dashboard/" class="btn btn-success btn-sm">Go to Dashboard</a>
                <button id="logout-btn" class="btn btn-warning btn-sm">Logout</button>
            </div>
        </div>
    <?php else: ?>
        <h3 class="mb-3 text-center">Login</h3>
        <form id="customLoginForm">
            <div class="form-group mb-3">
                <label for="email" class="form-label">Email</label>
                <input type="email" name="email" id="email" class="form-control" required placeholder="Enter your email">
            </div>
            <div class="form-group mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" name="password" id="password" class="form-control" required placeholder="Enter your password">
            </div>
            <button type="submit" class="btn btn-primary w-100">Login</button>
        </form>
    <?php endif; ?>
</div>

<style>
.custom-login-block {
    max-width: 400px;
    margin: 50px auto;
    padding: 40px;
    border-radius: 12px;
    background: linear-gradient(145deg, #ffffff, #e6e6e6);
    box-shadow: 0 10px 20px rgba(0,0,0,0.1);
}
#flash-messages .alert {
    margin-bottom: 15px;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('customLoginForm');
    const flashContainer = document.getElementById('flash-messages');

    form?.addEventListener('submit', async function(e) {
        e.preventDefault();
        flashContainer.innerHTML = '';

        const email = document.getElementById('email').value;
        const password = document.getElementById('password').value;

        try {
            const response = await fetch('http://172.23.183.41:8040/graphql/login-user', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    query: `
                        mutation LoginRegisterUser($email: String!, $password: String!) {
                            loginRegisterUser(email: $email, password: $password) {
                                id
                                username
                                email
                                password
                                token
                                created_at
                                updated_at
                            }
                        }
                    `,
                    variables: { email, password }
                })
            });

            const data = await response.json();

            if (data.errors) {
                data.errors.forEach(err => {
                    flashContainer.innerHTML += `<div class="alert alert-danger">❌ ${err.message}</div>`;
                });
                return;
            }

            const user = data.data.loginRegisterUser;
            const token = user.token;
            const username = user.username;

            // Save token & username in localStorage
            localStorage.setItem('authToken', token);
            localStorage.setItem('username', username);
            console.log('User logged in:', username);

            flashContainer.innerHTML = `<div class="alert alert-success">✅ Login successful! Redirecting...</div>`;

            setTimeout(() => {
                window.location.href = '/user-dashboard/';
            }, 1000);

        } catch (err) {
            flashContainer.innerHTML = `<div class="alert alert-danger">❌ Network error. Please try again.</div>`;
            console.error(err);
        }
    });

    // Logout button
    const logoutBtn = document.getElementById('logout-btn');
    logoutBtn?.addEventListener('click', () => {
        localStorage.removeItem('authToken');
        localStorage.removeItem('username');
        location.reload();
    });
});
</script>
