<?php defined('C5_EXECUTE') or die("Access Denied."); ?>

<div id="calendar-controls" style="margin-bottom:10px; text-align:center;">
    <button id="prev-month">⬅ Prev</button>
    <span id="calendar-title" style="margin:0 15px; font-weight:bold;"></span>
    <button id="next-month">Next ➡</button>
</div>
<div id="event-calendar"></div>

<!-- Event Detail Modal -->
<div id="event-modal" class="event-modal">
    <div class="event-modal-content">
        <span class="event-modal-close">&times;</span>
        <div id="event-modal-body"></div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const calendarEl = document.getElementById("event-calendar");
    const titleEl = document.getElementById("calendar-title");
    const prevBtn = document.getElementById("prev-month");
    const nextBtn = document.getElementById("next-month");

    const modal = document.getElementById("event-modal");
    const modalBody = document.getElementById("event-modal-body");
    const modalClose = document.querySelector(".event-modal-close");

    const graphqlEndpoint = "http://172.23.183.41:8040/graphql/event";

    const query = `
       query Events {
            events {
                id
                event_name
                short_description
                start_date
                start_time
                end_date
                end_time
                location_name
                address_1
                address_2
                city
                country
                state
                phone
                zip_code
                publish_contact
                view_on_calendar
                global_event
                event_registration
                description
                registration_open_date
                registration_close_date
                require_billing_info
                required_payment
                require_tickets
                attendee_signup
                attendee_memo
                created_at
                updated_at
            }
        }
    `;

    let current = new Date(); // current month
    let allEvents = []; // store globally for modal use

    function renderCalendar(events, year, month) {
        const daysInMonth = new Date(year, month + 1, 0).getDate();

        // Group events by day
        const eventMap = {};
        events.forEach(e => {
            if (!e.start_date) return;
            const parts = e.start_date.split("-");
            const y = parseInt(parts[0], 10);
            const m = parseInt(parts[1], 10) - 1;
            const d = parseInt(parts[2], 10);

            if (y === year && m === month) {
                if (!eventMap[d]) eventMap[d] = [];
                eventMap[d].push(e);
            }
        });

        // Build calendar HTML
        let html = "<table class='event-calendar'>";
        html += "<thead><tr>";
        const daysOfWeek = ["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];
        daysOfWeek.forEach(d => { html += `<th>${d}</th>`; });
        html += "</tr></thead><tbody><tr>";

        const firstDay = new Date(year, month, 1).getDay();

        // Empty cells before first day
        for (let i = 0; i < firstDay; i++) {
            html += "<td class='empty'></td>";
        }

        for (let day = 1; day <= daysInMonth; day++) {
            let cellContent = `<div class='day-number'>${day}</div>`;
            if (eventMap[day]) {
                eventMap[day].forEach(ev => {
                    cellContent += `<button class="event-badge" data-id="${ev.id}">${ev.event_name}</button>`;
                });
            }
            html += `<td>${cellContent}</td>`;
            if ((day + firstDay) % 7 === 0) html += "</tr><tr>";
        }

        html += "</tr></tbody></table>";

        // Update DOM
        titleEl.textContent = new Date(year, month).toLocaleString('default', { month: 'long', year: 'numeric' });
        calendarEl.innerHTML = html;

        // Attach event listeners to event badges
        document.querySelectorAll(".event-badge").forEach(btn => {
            btn.addEventListener("click", () => {
                const eventId = btn.getAttribute("data-id");
                const event = allEvents.find(e => e.id == eventId);
                if (event) showEventModal(event);
            });
        });
    }

    function showEventModal(event) {
        modalBody.innerHTML = `
            <h2>${event.event_name}</h2>
            <p><strong>Start Date:</strong> ${event.start_date}</p>
            <p><strong>End Date:</strong> ${event.end_date}</p>
            <p><strong>Location:</strong> ${event.location_name || ''}</p>
            <p><strong>City:</strong> ${event.city || ''}</p>
            <p><strong>Country:</strong> ${event.country || ''}</p>
            <p><strong>Description:</strong><br>${event.description || ''}</p>
        `;
        modal.style.display = "flex";
    }

    function fetchAndRender(year, month) {
        fetch(graphqlEndpoint, {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ query })
        })
        .then(res => res.json())
        .then(data => {
            console.log("GraphQL Response:", data);

            // Fixed: Access the correct property based on the query
            if (!data.data || !data.data.events) {
                console.error("No events data found in response");
                calendarEl.innerHTML = "<p>No events found.</p>";
                return;
            }

            allEvents = data.data.events;
            console.log("Events loaded:", allEvents.length);
            renderCalendar(allEvents, year, month);
        })
        .catch(err => {
            console.error("Fetch error:", err);
            calendarEl.innerHTML = "<p>Error fetching events.</p>";
        });
    }

    // Initial load
    fetchAndRender(current.getFullYear(), current.getMonth());

    // Button actions
    prevBtn.addEventListener("click", () => {
        current.setMonth(current.getMonth() - 1);
        fetchAndRender(current.getFullYear(), current.getMonth());
    });

    nextBtn.addEventListener("click", () => {
        current.setMonth(current.getMonth() + 1);
        fetchAndRender(current.getFullYear(), current.getMonth());
    });

    // Close modal
    modalClose.addEventListener("click", () => { modal.style.display = "none"; });
    window.addEventListener("click", (e) => { if (e.target === modal) modal.style.display = "none"; });
});
</script>

<style>
.event-calendar { border-collapse: collapse; width: 100%; text-align: center; margin-top:10px; }
.event-calendar th, .event-calendar td { border: 1px solid #ccc; padding: 8px; vertical-align: top; width: 14%; min-height:80px; }
.event-calendar .day-number { font-weight: bold; margin-bottom: 4px; }
.event-badge {
    background: #007BFF;
    color: white;
    border: none;
    border-radius: 4px;
    padding: 2px 4px;
    margin: 2px 0;
    display: block;
    font-size: 12px;
    cursor: pointer;
}
.event-badge:hover { background: #0056b3; }
.event-calendar .empty { background: #f9f9f9; }
#calendar-controls button {
    background: #007BFF;
    color: white;
    border: none;
    padding: 6px 12px;
    border-radius: 4px;
    cursor: pointer;
}
#calendar-controls button:hover { background: #0056b3; }

/* Modal Styling */
.event-modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0; top: 0;
    width: 100%; height: 100%;
    background: rgba(0,0,0,0.6);
    align-items: center;
    justify-content: center;
}
.event-modal-content {
    background: #fff;
    padding: 20px;
    border-radius: 8px;
    max-width: 500px;
    width: 90%;
    box-shadow: 0 5px 15px rgba(0,0,0,0.3);
    position: relative;
}
.event-modal-close {
    position: absolute;
    right: 12px;
    top: 8px;
    font-size: 24px;
    cursor: pointer;
}
</style>
