<?php defined('C5_EXECUTE') or die("Access Denied."); ?>

<div id="registration-block"></div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const container = document.getElementById("registration-block");

    const graphqlEndpoint = "http://172.23.183.41:8040/graphql/registration";

    const query = `
        query Registrations {
            registrations {
                id
                registration_link
                registration_description
                start_date
                end_date
                fees
                late_fee
                created_at
                updated_at
            }
        }
    `;

    fetch(graphqlEndpoint, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ query })
    })
    .then(res => res.json())
    .then(data => {
        // console.log("Registration Response:", data);

        // FIX: Change from getAllRegistrations to registrations
        if (!data.data || !data.data.registrations || data.data.registrations.length === 0) {
            container.innerHTML = "<p>No registration available.</p>";
            return;
        }

        // FIX: Access registrations instead of getAllRegistrations
        const reg = data.data.registrations[0]; // only one registration expected

        // Current date
        const today = new Date().toISOString().split("T")[0]; // YYYY-MM-DD

        const startDate = reg.start_date;
        const endDate = reg.end_date;

        // Check if today is within range
        const showButton = today >= startDate && today <= endDate;

        let html = `
            <div class="registration-box">
                <p class="registration-message">${reg.registration_description || "Registration is available."}</p>
        `;

        if (showButton && reg.registration_link) {
            html += `<a href="${reg.registration_link}" target="_blank" class="registration-btn">Register Now</a>`;
        } else {
            html += `<p class="registration-closed">Registration is closed.</p>`;
        }

        html += "</div>";

        container.innerHTML = html;
    })
    .catch(err => {
        container.innerHTML = "<p>Error loading registration info.</p>";
        console.error("Fetch error:", err);
    });
});
</script>

<style>
.registration-box {
    border: 1px solid #ccc;
    padding: 20px;
    text-align: center;
    border-radius: 8px;
    /* max-width: 400px; */
    margin: 20px auto;
    background: #f9f9f9;
}
.registration-message {
    font-size: 16px;
    margin-bottom: 15px;
    font-weight: 500;
}
.registration-btn {
    display: inline-block;
    background: #28a745;
    color: white;
    text-decoration: none;
    padding: 10px 20px;
    border-radius: 6px;
    font-weight: bold;
    transition: background 0.3s;
}
.registration-btn:hover {
    background: #218838;
}
.registration-closed {
    color: red;
    font-weight: bold;
}
</style>
