<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$cart = isset($_SESSION['cart']) && is_array($_SESSION['cart']) ? $_SESSION['cart'] : [];
$total = 0;
?>

<section class="cart">
  <h2>Your Shopping Cart</h2>

  <?php if (!empty($cart)) : ?>
    <table>
      <thead>
        <tr>
          <th>Product</th>
          <th>Price</th>
          <th>Quantity</th>
          <th>Subtotal</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($cart as $item) : ?>
          <?php
            // Ensure it's an array
            if (!is_array($item)) continue;

            $itemTotal = $item['price'] * $item['qty'];
            $total += $itemTotal;
          ?>
          <tr>
            <td><?= htmlspecialchars($item['name']) ?></td>
            <td>$<?= number_format($item['price'], 2) ?></td>
            <td><?= (int)$item['qty'] ?></td>
            <td>$<?= number_format($itemTotal, 2) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <div class="cart-summary">
      <h3>Total: $<?= number_format($total, 2) ?></h3>
      <button class="checkout-btn">Proceed to Checkout</button>
    </div>
  <?php else : ?>
    <p class="empty-msg">Your cart is empty.</p>
  <?php endif; ?>
</section>

<style>
  .cart table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 20px;
  }
  .cart th, .cart td {
    border: 1px solid #ddd;
    padding: 10px;
    text-align: center;
  }
  .cart th { background: #f4f4f4; }
  .cart-summary {
    text-align: right;
    margin-top: 15px;
  }
  .checkout-btn {
    padding: 10px 20px;
    background: #007bff;
    border: none;
    color: white;
    border-radius: 5px;
    cursor: pointer;
  }
  .checkout-btn:hover { background: #0056b3; }
  .empty-msg { color: #777; }
</style>
