<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Ensure cart session is always an array
if (!isset($_SESSION['cart']) || !is_array($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// Handle Add to Cart
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_to_cart'])) {
    $product = [
        'id'    => isset($_POST['id']) ? (int) $_POST['id'] : 0,
        'name'  => isset($_POST['name']) ? (string) $_POST['name'] : '',
        'price' => isset($_POST['price']) ? (float) $_POST['price'] : 0,
        'image' => isset($_POST['image']) ? (string) $_POST['image'] : '',
    ];

    if ($product['id'] > 0) {
        $found = false;

        foreach ($_SESSION['cart'] as &$item) {
            if (!is_array($item)) {
                continue;
            }

            if ($item['id'] === $product['id']) {
                $item['qty'] += 1;
                $found = true;
                break;
            }
        }

        if (!$found) {
            $product['qty'] = 1;
            $_SESSION['cart'][] = $product;
        }
    }
}
?>

<!-- Featured Products Grid -->
<section class="featured-products">
  <h2>League Store – Featured Products</h2>
  <div class="grid">
    <?php
    $products = [
        ['id' => 1, 'name' => 'Cricket Bat', 'price' => 120, 'image' => 'https://source.unsplash.com/300x200/?cricket,bat'],
        ['id' => 2, 'name' => 'Cricket Ball', 'price' => 25, 'image' => 'https://source.unsplash.com/300x200/?cricket,ball'],
        ['id' => 3, 'name' => 'Football', 'price' => 45, 'image' => 'https://source.unsplash.com/300x200/?football'],
        ['id' => 4, 'name' => 'Tennis Racket', 'price' => 90, 'image' => 'https://source.unsplash.com/300x200/?tennis,racket'],
        ['id' => 5, 'name' => 'Sports Jersey', 'price' => 60, 'image' => 'https://source.unsplash.com/300x200/?jersey,sports'],
        ['id' => 6, 'name' => 'Sports T-Shirt', 'price' => 30, 'image' => 'https://source.unsplash.com/300x200/?tshirt,sports'],
        ['id' => 7, 'name' => 'Sports Shoes', 'price' => 75, 'image' => 'https://source.unsplash.com/300x200/?sports,shoes'],
        ['id' => 8, 'name' => 'Badminton Shuttlecock', 'price' => 12, 'image' => 'https://source.unsplash.com/300x200/?badminton,shuttle'],
        ['id' => 9, 'name' => 'Baseball Cap', 'price' => 20, 'image' => 'https://source.unsplash.com/300x200/?cap,sports'],
        ['id' => 10, 'name' => 'Water Bottle', 'price' => 15, 'image' => 'https://source.unsplash.com/300x200/?sports,bottle'],
    ];

    foreach ($products as $p): ?>
      <div class="card">
        <img src="<?= htmlspecialchars($p['image']) ?>" alt="<?= htmlspecialchars($p['name']) ?>">
        <h3><?= htmlspecialchars($p['name']) ?></h3>
        <p>$<?= number_format($p['price'], 2) ?></p>
        <form method="post">
          <input type="hidden" name="id" value="<?= $p['id'] ?>">
          <input type="hidden" name="name" value="<?= htmlspecialchars($p['name']) ?>">
          <input type="hidden" name="price" value="<?= $p['price'] ?>">
          <input type="hidden" name="image" value="<?= $p['image'] ?>">
          <button type="submit" name="add_to_cart">Add to Cart</button>
        </form>
      </div>
    <?php endforeach; ?>
  </div>

  <div class="cart-btn">
    <a href="cart.php">🛒 View Cart (<?= count($_SESSION['cart']); ?>)</a>
  </div>
</section>


<style>
/* --- General --- */
body {
  font-family: "Poppins", sans-serif;
  background: #f9f9f9;
  color: #333;
  margin: 0;
  padding: 0;
}
.featured-products {
  margin: 50px auto;
  max-width: 1200px;
  padding: 0 20px;
  text-align: center;
}
.featured-products h2 {
  font-size: 2rem;
  margin-bottom: 25px;
  font-weight: 700;
  color: #222;
}

/* --- Grid --- */
.grid {
  display: grid;
  grid-template-columns: repeat(4, 1fr);
  gap: 20px;
}
.card {
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.1);
  text-align: center;
  padding: 15px;
  transition: transform 0.3s, box-shadow 0.3s;
}
.card:hover {
  transform: translateY(-6px);
  box-shadow: 0 8px 20px rgba(0,0,0,0.15);
}
.card img {
  max-width: 100%;
  height: 180px;
  object-fit: cover;
  border-radius: 8px;
}
.card h3 {
  margin: 12px 0 6px;
  font-size: 1.1rem;
  color: #111;
}
.card p {
  font-size: 1rem;
  color: #28a745;
  font-weight: 600;
  margin-bottom: 12px;
}

/* --- Button --- */
button[name="add_to_cart"] {
  background: linear-gradient(45deg, #28a745, #218838);
  color: white;
  border: none;
  padding: 10px 15px;
  font-size: 0.9rem;
  border-radius: 6px;
  cursor: pointer;
  transition: transform 0.2s, background 0.3s;
}
button[name="add_to_cart"]:hover {
  background: linear-gradient(45deg, #218838, #1e7e34);
  transform: scale(1.05);
}

/* --- Cart Button --- */
.cart-btn {
  margin-top: 30px;
}
.cart-btn a {
  display: inline-block;
  background: #007bff;
  color: #fff;
  padding: 12px 18px;
  border-radius: 6px;
  font-weight: 500;
  text-decoration: none;
  transition: background 0.3s, transform 0.2s;
}
.cart-btn a:hover {
  background: #0056b3;
  transform: scale(1.05);
}

/* --- Responsive --- */
@media (max-width: 992px) {
  .grid {
    grid-template-columns: repeat(3, 1fr);
  }
}
@media (max-width: 768px) {
  .grid {
    grid-template-columns: repeat(2, 1fr);
  }
}
@media (max-width: 480px) {
  .grid {
    grid-template-columns: 1fr;
  }
  .card img {
    height: 150px;
  }
}
</style>
