<?php defined('C5_EXECUTE') or die("Access Denied.");

use Concrete\Core\Support\Facade\Url;

$this->inc('elements/header_top.php');

$as = new GlobalArea('Header Search');
$blocks = $as->getTotalBlocksInArea();
$displayThirdColumn = $blocks > 0 || $c->isEditMode();
?>

<header style="padding-top: 10px; padding-bottom: 10px;">
    <div class="container" >
       <div class="row align-items-center">
    <!-- Left Column: Logo / Title -->
    <div class="col-6 col-md-4">
        <?php
        $a = new GlobalArea('Header Site Title');
        $a->display();
        ?>
    </div>

    <!-- Right Column: Navigation -->
    <div class="<?php echo ($displayThirdColumn) ? 'col-6 col-md-8' : 'col-6 col-md-8'; ?>">
        <?php
        // --- CUSTOM NAV START ---
        ob_start();
        $a = new GlobalArea('Header Navigation');
        $a->display();
        $navHtml = ob_get_clean();
        echo $navHtml;
        // --- CUSTOM NAV END ---
        ?>
    </div>
</div>

    </div>
</header>

<script>
document.addEventListener('DOMContentLoaded', () => {
    // Function to get cookie value
    const getCookie = (name) => {
        const value = `; ${document.cookie}`;
        const parts = value.split(`; ${name}=`);
        if (parts.length === 2) return parts.pop().split(';').shift();
        return null;
    };

    // Find login links (text or href containing login)
    const loginLinks = [...document.querySelectorAll('a[href*="login"], a')]
        .filter(link => link.textContent.trim().toLowerCase() === 'login' || link.href.includes('login'));

    if (loginLinks.length > 0) {
        // Check if authToken exists in localStorage
        const authToken = localStorage.getItem('authToken');

        if (authToken) {
            // Replace login link with "Dashboard"
            loginLinks.forEach(link => {
                link.textContent = 'Dashboard';
                link.href = '/user-dashboard/';
            });

            // Add logout option if not already present
            const navUl = loginLinks[0].closest('ul');
            if (navUl && !document.querySelector('#header-logout')) {
                const li = document.createElement('li');
                li.id = 'header-logout';
                li.className = 'nav-item';
                li.innerHTML = `<a class="nav-link" href="/log-in?logout=1">Logout</a>`;
                navUl.appendChild(li);
            }
        }
    }
});
</script>

