<?php defined('C5_EXECUTE') or die("Access Denied.");

use Concrete\Core\User\User;
use Concrete\Core\Support\Facade\Url;

$this->inc('elements/header_top.php');

$as = new GlobalArea('Header Search');
$blocks = $as->getTotalBlocksInArea();
$displayThirdColumn = $blocks > 0 || $c->isEditMode();
?>

<header>
    <div class="container">
        <div class="row">
            <div class="col-sm-4 col-xs-6">
                <?php
                $a = new GlobalArea('Header Site Title');
                $a->display();
                ?>
            </div>
            <div class="<?php echo ($displayThirdColumn) ? 'col-sm-5 col-xs-6' : 'col-sm-8 col-xs-6' ?>">
                <?php
                // --- CUSTOM NAV START ---
                ob_start();
                $a = new GlobalArea('Header Navigation');
                $a->display();
                $navHtml = ob_get_clean();

                // $u = new User();
                // if ($u->isRegistered()) {
                //     $username = h($u->getUserName());

                //     // replace "Login" text with username
                //     $navHtml = preg_replace('/>Login</i', '>' . $username . '<', $navHtml);

                //     // add logout link before </ul>
                //     $logoutLink = '<li class="nav-item"><a class="nav-link" href="' . Url::to('/login', 'logout') . '">Logout</a></li>';
                //     $navHtml = str_replace('</ul>', $logoutLink . '</ul>', $navHtml);
                // }

                // check if custom login session exists
// if (!empty($_SESSION['custom_username'])) {
//     $username = h($_SESSION['custom_username']);

//     // replace "Login" text with username
//     $navHtml = preg_replace('/>Login</i', '>' . $username . '<', $navHtml);

//     // add logout link before </ul>
//     $logoutLink = '<li class="nav-item"><a class="nav-link" href="' . Url::to('/login', 'logout') . '">Logout</a></li>';
//     $navHtml = str_replace('</ul>', $logoutLink . '</ul>', $navHtml);
// }


// if (!empty($_SESSION['custom_username'])) {
//     $username = h($_SESSION['custom_username']);

//     // replace "Login" text with username and change URL to profile/dashboard
//     $navHtml = preg_replace(
//         '/<a[^>]*>Login<\/a>/i',
//         '<a href="' . Url::to('/dashboard') . '">' . $username . '</a>',
//         $navHtml
//     );

//     // optionally add logout link before </ul>
//     $logoutLink = '<li class="nav-item"><a class="nav-link" href="' . Url::to('/log-in') . '?logout=1">Logout</a></li>';
//     $navHtml = str_replace('</ul>', $logoutLink . '</ul>', $navHtml);
// }


if (!empty($_SESSION['custom_username'])) {
    $username = htmlspecialchars($_SESSION['custom_username'], ENT_QUOTES, 'UTF-8');

    // Replace Login text with username and custom dashboard URL
    $navHtml = preg_replace(
        '/<a[^>]*>Login<\/a>/i',
        '<a href="/concrete/concrete-cms-9.2.8/userdashboard/">' . $username . '</a>',
        $navHtml
    );

    // Add Logout link before </ul>
    $logoutLink = '<li class="nav-item"><a class="nav-link" href="/concrete/concrete-cms-9.2.8/log-in/index.php?logout=1">Logout</a></li>';
    $navHtml = str_replace('</ul>', $logoutLink . '</ul>', $navHtml);
}
                echo $navHtml;
                // --- CUSTOM NAV END ---
                ?>
            </div>
            <?php if ($displayThirdColumn) { ?>
                <div class="col-sm-3 col-xs-12">
                    <?php $as->display(); ?>
                </div>
            <?php } ?>
        </div>
    </div>
</header>
