<?php
// Display errors for debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);

define('C5_EXECUTE', true);

// Define Concrete CMS root
define('DIR_BASE', realpath(__DIR__ . '/..'));

// Include Concrete dispatcher (bootstraps CMS)
require_once DIR_BASE . '/concrete/dispatcher.php';

use Concrete\Core\Foundation\Environment;

// =========================
// CONFIGURE YOUR THEME
// =========================
// Replace 'my_theme' with the folder name of your active theme
$activeTheme = 'my_theme';

// Get theme paths
$env = Environment::get();
$themePath = DIR_BASE . '/application/themes/' . $activeTheme;

// Optional: include theme CSS/JS manually if header.php doesn't load them
// echo '<link rel="stylesheet" href="/application/themes/' . $activeTheme . '/main.css">';

// =========================
// INCLUDE HEADER
// =========================
if (file_exists($themePath . '/elements/header.php')) {
    include $themePath . '/elements/header.php';
} else {
    echo "<!-- Header file not found in theme: $activeTheme -->";
}
?>

<!-- =========================
     CUSTOM WEBSTORE CONTENT
========================= -->
<main style="padding: 20px;">
    <h1>My Webstore</h1>
    <p>Welcome to your custom store page!</p>

    <div class="product-list" style="display: flex; gap: 20px; flex-wrap: wrap;">
        <div class="product" style="border: 1px solid #ccc; padding: 10px; flex: 1 1 200px;">
            <h3>Product 1</h3>
            <p>Price: $10</p>
        </div>
        <div class="product" style="border: 1px solid #ccc; padding: 10px; flex: 1 1 200px;">
            <h3>Product 2</h3>
            <p>Price: $15</p>
        </div>
    </div>
</main>

<?php
// =========================
// INCLUDE FOOTER
// =========================
if (file_exists($themePath . '/elements/footer.php')) {
    include $themePath . '/elements/footer.php';
} else {
    echo "<!-- Footer file not found in theme: $activeTheme -->";
}
?>
